Option Explicit
Const scriptName = "Layout Calendar"
Const scriptVer = "1.0.1"

' Revision History

' 1.0.1 - July 23, 2002 - MJM - Changed to use ElementByName to get the elements.
' 1.0.0 - July 23, 2002 - MJM - Inital version.


' Script Properties
Const kMonthShapeName = "Month"
Const kYearShapeName = "Year"
Const kCalendarShapeName = "Calendar"

' Script constants, questions, and error messages.
Const qMonth = "Make a calendar for which month?"
Const qYear = "Make a calendar for which year?"

Const errInvalidDate = " is not a valid date."
Const errWrongDocumentType = "This script requires an open calendar template."

Dim crTabChar
crTabChar = Chr(9)

Dim crParagraphChar
crParagraphChar = Chr(13)




' Main

Dim errNum
errNum = 0

Dim continueOn
continueOn = True

' Init Creator:
Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

' Check for the three shapes' text flows.
Dim TempShape
Dim MonthFlow, YearFlow, CalendarFlow
If CreatorApp.Documents.Count = 0 Then 
  Call MsgBox(errWrongDocumentType, vbOkonly, scriptName) 
  errNum = -1 
End If 

If errNum = 0 Then 
  On Error Resume Next 
  Set TempShape = CreatorApp.ActiveDocument.ElementByName(kMonthShapeName)
  errNum = Err.Number 
  If errNum = 0 Then
    Set MonthFlow = TempShape.TextFlow
    errNum = Err.Number
  End If
  On Error GoTo 0 
  
  If errNum <> 0 Then 
    Call MsgBox(errWrongDocumentType, vbOkonly, scriptName) 
  End If
End If

If errNum = 0 Then 
  Set TempShape = CreatorApp.ActiveDocument.ElementByName(kYearShapeName)
  errNum = Err.Number 
  If errNum = 0 Then
    Set YearFlow = TempShape.TextFlow
    errNum = Err.Number
  End If
  On Error GoTo 0 
  
  If errNum <> 0 Then 
    Call MsgBox(errWrongDocumentType, vbOkonly, scriptName) 
  End If
End If

If errNum = 0 Then 
  Set TempShape = CreatorApp.ActiveDocument.ElementByName(kCalendarShapeName)
  errNum = Err.Number 
  If errNum = 0 Then
    Set CalendarFlow = TempShape.TextFlow
    errNum = Err.Number
  End If
  On Error GoTo 0 
  
  If errNum <> 0 Then 
    Call MsgBox(errWrongDocumentType, vbOkonly, scriptName) 
  End If
End If

Set TempShape = Nothing

Dim startDate
Dim monthText, yearText

If errNum = 0 Then
  continueOn = False
  monthText = MonthName(Month(Date()))
  yearText = Year(Date())
  
  Do
    monthText = InputBox(qMonth, scriptName, monthText)
    If monthText = "" Then
      continueOn = True
      errNum = -1
    Else
      yearText = InputBox(qYear, scriptName, yearText)
      If yearText = "" Then
        continueOn = True
        errNum = -1    
      Else
        On Error Resume Next
        continueOn = IsDate(monthText & " " & yearText)
        errNum = Err.Number
        On Error Goto 0

        If errNum <> 0 Or Not ContinueOn Then
          Call MsgBox(monthText & " " & yearText & errInvalidDate, vbOkonly, scriptName)
        Else
          startDate = DateValue(monthText & ", " & yearText)      
        End If
      End If
    End If
  Loop Until continueOn = True
End If


If errNum = 0 Then
  Dim nextMonth
  Dim startDay, dayCount, weekCount
  Dim calendarText
  Dim weekdayCounter, dayCounter

  ' The weekday starting day.
  ' (Our prefab calendar template has Sunday as the weekday start day;
  '  if you want a different one or if the script changes to ask for it,
  '  here Is where you change it.)
  startDay = DatePart("w", startDate, vbSunday)
  

  ' and how many days to fill
  nextMonth = DateAdd("m", 1, startDate)
  dayCount = DateDiff("d", startDate, nextMonth)
  
  ' Fix the month and year to long versions:
  monthText = MonthName(Month(startDate))
  yearText = Year(startDate)

  ' Generate the calendar text, with returns at the end of the week.
  ' (If we ever make the script fix for different weekday starts,
  '  this shouldn't need to change.  Yay!)
  calendarText = ""
  
  For dayCounter = 1 To startDay
    calendarText = calendarText & crTabChar
  Next
  
  dayCounter = 1
  weekdayCounter = startDay
  
  Do
    calendarText = calendarText & dayCounter
    If weekdayCounter = 7 Then
      weekdayCounter = 1
      calendarText = calendarText & crParagraphChar & crTabChar
    Else
      weekdayCounter = weekdayCounter + 1
      calendarText = calendarText & crTabChar
    End If
    dayCounter = dayCounter + 1
  Loop Until dayCounter = dayCount
  
  calendarText = calendarText & dayCounter

  ' And the actual assignments:
  MonthFlow.Text = monthText
  YearFlow.Text = yearText
  CalendarFlow.Text = calendarText
End If
